/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.stream;

import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsException;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.IncomingStreamEvent;
import com.ibm.hwmca.fw.fcs.impl.FcsConnectionManager;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class StreamReceiver
implements FcsService {
    private static final String TRACE_MASKD = "XFCSSTRD";
    private static final String TRACE_MASKF = "XFCSSTRF";
    private static final String TRACE_MASKT = "XFCSSTRT";
    private FcsConnection connection;
    private int parentConnectionId;

    public void processConnection(FcsConnection connection) {
        this.connection = connection;
        try {
            connection.getSocket().setSoTimeout(120000);
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(connection.getSocket().getInputStream()));
            Integer integer = (Integer)ois.readObject();
            this.parentConnectionId = integer;
            String title = (String)ois.readObject();
            IncomingStreamEvent event = new IncomingStreamEvent(title, connection.getSocket().getInputStream());
            FcsConnection parentConnection = FcsConnectionManager.getConnection(this.parentConnectionId);
            if (parentConnection != null) {
                parentConnection.fireIncomingStreamEvent(event);
            }
        }
        catch (IOException ioe) {
            this.log(new FcsException(ioe));
        }
        catch (ClassNotFoundException cnfe) {
            this.log(new FcsException(cnfe));
        }
    }

    private void log(FcsException fcse) {
        Trace.trace(TRACE_MASKF, "StreamReceiver caught: " + fcse.getMessage());
    }

    public FcsConnection getFcsConnection() {
        return this.connection;
    }
}

